<?php
if (!defined('MODULE_FILE')) {
	Header("Location: ../../index.php");
	exit;
}
$module_name = basename(dirname(__FILE__));
get_lang($module_name);
include("modules/$module_name/navi.php");
if ($forum) include("function/forum.php");
include("config/config_fields.php");

function checkuser($user_name, $user_email, $rulescheck) {
    global $stop, $prefix, $db, $name_blocker, $mail_blocker;
	if ($rulescheck != "1") $stop = ""._ERROR_RULES."";
	checkemail($user_email);
	$mail_blocker = explode(",", $mail_blocker);
	foreach ($mail_blocker as $key => $val) {
		if ($val == strtolower($user_email) && $val != "") $stop = ""._MAIL_BLOCK."";
	}
	$name_blocker = explode(",", $name_blocker);
	foreach ($name_blocker as $key => $val) {
		if ($val == strtolower($user_name) && $val != "") $stop = ""._NAME_BLOCK."";
	}
	if (!$user_name || preg_match("/[^a-zA-Z--0-9_- ]/", $user_name)) $stop = ""._ERRORINVNICK."";
    if (strlen($user_name) > 25) $stop = ""._NICK2LONG."";
	#if (strrpos($user_name, " ") > 0) $stop = ""._NICKNOSPACES."";

    if ($db->sql_numrows($db->sql_query("SELECT user_name FROM ".$prefix."_users WHERE user_name='$user_name'")) > 0) $stop = ""._NICKTAKEN."";
    if ($db->sql_numrows($db->sql_query("SELECT user_name FROM ".$prefix."_users_temp WHERE user_name='$user_name'")) > 0) $stop = ""._NICKTAKEN."";
    if ($db->sql_numrows($db->sql_query("SELECT user_email FROM ".$prefix."_users WHERE user_email='$user_email'")) > 0) $stop = ""._EMAILREGISTERED."";
    if ($db->sql_numrows($db->sql_query("SELECT user_email FROM ".$prefix."_users_temp WHERE user_email='$user_email'")) > 0) $stop = ""._EMAILREGISTERED."";
    return($stop);
}

function newuser() {
    global $my_headlines, $module_name, $db, $gfx_chk;
    if (!is_user($user)) {
        head();
		title(""._REGNEWUSER."");
        OpenTable();
        echo "<table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" align=\"center\">"
		."<form action=\"index.php?name=$module_name\" method=\"post\">"
		."<tr><td>"._NICKNAME.":</td><td colspan=\"2\"><input type=\"text\" name=\"user_name\" size=\"30\" maxlength=\"25\"></td></tr>"
		."<tr><td>"._EMAIL.":</td><td colspan=\"2\"><input type=\"text\" name=\"user_email\" size=\"30\" maxlength=\"255\"></td></tr>"
		."<tr><td>"._PASSWORD.":</td><td><input type=\"password\" name=\"user_password\" size=\"25\" maxlength=\"10\"></td><td><img src=\"images/info.gif\" border=\"0\" title=\""._BLANKFORAUTO."\"></td></tr>"
		."<tr><td>"._RETYPEPASSWORD.":</td><td><input type=\"password\" name=\"user_password2\" size=\"25\" maxlength=\"10\"></td><td><img src=\"images/info.gif\" border=\"0\" title=\""._BLANKFORAUTO."\"></td></tr>";
		if (extension_loaded("gd") AND ($gfx_chk == 3 OR $gfx_chk == 4 OR $gfx_chk == 6 OR $gfx_chk == 7)) {
            echo "<tr><td>"._SECURITY_CODE.":</td><td colspan=\"2\"><img src=\"index.php?captcha=1\" border=\"1\" alt=\""._SECURITY_CODE."\" title=\""._SECURITY_CODE."\"></td></tr>"
			."<tr><td>"._TYPESECCODE.":</td><td colspan=\"2\"><input type=\"text\" name=\"check\" size=\"10\" maxlength=\"6\"></td></tr>";
        }
        echo "<tr><td colspan=\"3\" style=\"width:300px\"><textarea cols=\"50\" rows=\"10\">"._RULES."</textarea></td></tr>"
		."<tr><td colspan=\"3\" style=\"width:300px\"><input type=\"checkbox\" name=\"rulescheck\" value=\"1\"> "._RULES_OK."</td></tr>"
		."<tr><td colspan=\"3\" align=\"center\"><br><input type=\"hidden\" name=\"op\" value=\"confnewuser\">"
		."<input type=\"submit\" value=\""._NEWUSER."\"></td></tr></form></table><br>"
		."<center>[ <a href=\"index.php?name=$module_name\">"._USERLOGIN."</a> | <a href=\"index.php?name=$module_name&op=passlost\">"._PASSWORDLOST."</a> ]</center>";
        CloseTable();
        foot();
    } elseif (is_user($user)) {
		info($user[1]);
    }
}

function confnewuser($user_name, $user_email, $rulescheck, $user_password, $user_password2, $check) {
    global $stop, $sitename, $module_name, $minpass, $no_mail_reg, $gfx_chk, $sitekey;
    head();
	$user_name = text_filter($user_name, 1);
	checkuser($user_name, $user_email, $rulescheck);
	$user_password = htmlspecialchars(stripslashes($user_password));
    $user_password2 = htmlspecialchars(stripslashes($user_password2));
	
	session_start();
	$code = substr(hexdec(md5("".date("F j")."".$_SESSION['captcha']."".$conf['sitekey']."")), 2, 6);
	$_SESSION['captcha1'] = $_SESSION['captcha'];
	unset($_SESSION['captcha']);

	if (extension_loaded("gd") AND $code != $check AND ($gfx_chk == 3 OR $gfx_chk == 4 OR $gfx_chk == 6 OR $gfx_chk == 7)) $stop = ""._SECCODEINCOR."";
	if ($user_password == "" && $user_password2 == "") {
		$user_password = gen_pass($minpass);
	} elseif ($user_password != $user_password2) {
		$stop = ""._PASSDIFFERENT."";
	} elseif ($user_password == $user_password2 AND strlen($user_password) < $minpass) {
		$stop = ""._CHARMIN.": $minpass";
	}
	if (!$stop) {
        title(""._USERFINALSTEP."");
        OpenTable();
        echo "<center>$user_name, "._USERCHECKDATA."";
		if ($no_mail_reg == 0) echo " "._YOUWILLRECEIVE."";
		echo "</center><hr>"
		."<table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" align=\"center\">"
		."<tr><td>"._UUSERNAME.":</td><td>$user_name</td></tr>"
		."<tr><td>"._EMAIL.":</td><td>$user_email</td></tr></table><br>";
		echo "<center><form action=\"index.php?name=$module_name\" method=\"post\">"
		.""._GOBACK." "
		."<input type=\"hidden\" name=\"check\" value=\"".$check."\">"
		."<input type=\"hidden\" name=\"user_name\" value=\"".$user_name."\">"
		."<input type=\"hidden\" name=\"user_email\" value=\"".$user_email."\">"
		."<input type=\"hidden\" name=\"rulescheck\" value=\"".$rulescheck."\">"
		."<input type=\"hidden\" name=\"user_password\" value=\"".$user_password."\">"
		."<input type=\"hidden\" name=\"op\" value=\"finnewuser\">"
		."<input type=\"submit\" value=\""._FINISH."\"></form></center>";
        CloseTable();
    } else {
		title(""._NEWUSERERROR."");
		warning("".$stop."<br /><br />"._GOBACK."", "", "", 1);
    }
    foot();
}

function finnewuser($user_name, $user_email, $rulescheck, $user_password, $check) {
    global $stop, $adminmail, $sitename, $Default_Theme, $prefix, $db, $storyhome, $module_name, $homeurl, $no_mail_reg, $gfx_chk, $sitekey;
    head();
    checkuser($user_name, $user_email, $rulescheck);
	$user_password = htmlspecialchars(stripslashes($user_password));

	session_start();
	$code = substr(hexdec(md5("".date("F j")."".$_SESSION['captcha1']."".$conf['sitekey']."")), 2, 6);
	unset($_SESSION['captcha1']);
	
	if (extension_loaded("gd") AND $code != $check AND ($gfx_chk == 3 OR $gfx_chk == 4 OR $gfx_chk == 6 OR $gfx_chk == 7)) $stop = ""._SECCODEINCOR."";
    if (!isset($stop)) {
        $check_num = md5(gen_pass(10));
        $time = time();
        $finishlink = "$homeurl/index.php?name=$module_name&op=activate&user_name=$user_name&check_num=$check_num";
        $new_password = md5($user_password);
        $new_password = htmlspecialchars(stripslashes($new_password));
        $user_name = text_filter($user_name);
        $user_email = text_filter($user_email);
        $result = $db->sql_query("INSERT INTO ".$prefix."_users_temp (user_id, user_name, user_email, user_password, user_regdate, check_num, time) VALUES (NULL, '$user_name', '$user_email', '$new_password', now(), '$check_num', '$time')");
		if ($no_mail_reg == 1) {
            title(""._ACCOUNTCREATED."");
			OpenTable(); 
			echo "<center>"._TOFINISHUSER."<hr><br>[ <a href=\"$finishlink\">"._ACTIVATIONSUB."</a> ]</center><br>";
			echo "<table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" align=\"center\">"
			."<tr><td colspan=\"2\"><font class=\"option\">"._FOLLOWINGMEM."</font></td></tr>"
			."<tr><td>"._UNICKNAME.":</td><td>$user_name</td></tr>"
			."<tr><td>"._UPASSWORD.":</td><td>$user_password</td></tr></table>";
			CloseTable();
		} else {
            $message = ""._WELCOMETO_AC." $sitename!<br /><br />"._YOUUSEDEMAIL.": $user_email "._TOREGISTER." $sitename.<br /><br />"._TOFINISHUSER."<br /><br /><a href=\"$finishlink\">$finishlink</a><br /><br />"._FOLLOWINGMEM."<br /><br />"._UNICKNAME.": $user_name<br />"._UPASSWORD.": $user_password";
            $subject = "$sitename - "._ACTIVATIONSUB."";
			mail_send($user_email, $adminmail, $subject, $message, 0, 3);
			title(""._ACCOUNTCREATED."");
			warning(""._YOUAREREGISTERED."<br /><br />"._FINISHUSERCONF."<br /><br />"._THANKSUSER." $sitename!", "", 15, 2);
		}
    } else {
		title(""._NEWUSERERROR."");
		warning("".$stop."<br /><br />"._GOBACK."", "", "", 1);
    }
    foot();
}

function activate() {
    global $db, $prefix, $module_name, $language, $forum;
	$user_name = htmlspecialchars(substr($_GET['user_name'], 0, 25));
	$check_num = htmlspecialchars(stripslashes($_GET['check_num']));
    $past = time()-86400;
    $db->sql_query("DELETE FROM ".$prefix."_users_temp WHERE time < '$past'");
    $result = $db->sql_query("SELECT * FROM ".$prefix."_users_temp WHERE user_name='$user_name' AND check_num='$check_num'");
	head();
    if ($db->sql_numrows($result) == 1) {
        $row = $db->sql_fetchrow($result);
        $user_password = htmlspecialchars(stripslashes($row['user_password']));
        if ($check_num == $row['check_num']) {
            $db->sql_query("INSERT INTO ".$prefix."_users (user_id, user_name, user_email, user_password, user_avatar, user_regdate, user_lang) VALUES (NULL, '$row[user_name]', '$row[user_email]', '$user_password', '00.gif', '$row[user_regdate]', '$language')");
            $db->sql_query("DELETE FROM ".$prefix."_users_temp WHERE user_name='$user_name' AND check_num='$check_num'");
			if ($forum) new_user($row['user_name'], $user_password, $row['user_email']);
            title(""._ACTIVATIONYES."");
			warning(""._ACTMSG."", "?name=Account", 10, 2);
        } else {
            title(""._ACTIVATIONERROR."");
			warning(""._ACTERROR1."", "?name=Account", 15, 1);
        }
    } else {
        title(""._ACTIVATIONERROR."");
		warning(""._ACTERROR2."", "?name=Account", 15, 1);
    }
	foot();
}

function info($uname, $hid=0, $url=0) {
    global $articlecomm, $user, $sitename, $prefix, $db, $admin, $conffi, $broadcast_msg, $my_headlines, $module_name, $defis, $pagetitle, $update_points, $admin_file, $adirectory;
	$user_name = trim(isset($_POST['uname']) ? $_POST['uname'] : $_GET['uname']);
	$user_name = ($uname) ? $uname : $user_name;
	$user_name = htmlspecialchars(substr($user_name, 0, 25));
    $result = $db->sql_query("SELECT * FROM ".$prefix."_users WHERE user_name='$user_name'");
	if ($db->sql_numrows($result) == 1) {
		$userinfo = $db->sql_fetchrow($result);
		$cookie = $user;
		if (is_user($user) AND (strtolower($user_name) == strtolower($cookie[1])) AND ($userinfo['user_password'] == $cookie[2])) {
			$pagetitle = "$defis "._THISISYOURPAGE."";
			head();
			OpenTable();
			echo "<center><font class=\"title\"><b>"._THISISYOURPAGE."</b></font></center>";
			CloseTable();
			OpenTable();
			nav('1');
			CloseTable();
		} else {
			$pagetitle = "$defis "._PERSONALINFO." $defis $user_name";
			head();
			$user_group = intval($userinfo['user_group']);
			if ($user_group) {
				list($gr_extra_name, $rank) = $db->sql_fetchrow($db->sql_query("SELECT name, rank FROM ".$prefix."_groups WHERE id='$user_group'"));
			} else {
				$user_points = intval($userinfo['user_points']);
				list($gr_extra_name, $rank) = $db->sql_fetchrow($db->sql_query("SELECT name, rank FROM ".$prefix."_groups WHERE points<='$user_points' AND extra!='1' ORDER BY points DESC"));
			}			
			OpenTable();
			$user_avatar = ($userinfo['user_avatar'] && file_exists("".$adirectory."/".$userinfo['user_avatar']."")) ? "<img src=\"".$adirectory."/".$userinfo['user_avatar']."\" alt=\"$user_name\" title=\"$user_name\" />" : "<img src=\"".$adirectory."/00.gif\" alt=\"$user_name\" title=\"$user_name\" />";
			$user_rank = ($rank && file_exists("images/ranks/".$rank."")) ? "<br /><img src=\"images/ranks/".$rank."\" border=\"0\" alt=\""._RANK."\" title=\""._RANK."\">" : "";
			echo "<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"1\" align=\"center\" class=\"bgcolor4\">"
			."<tr><th colspan=\"2\">"._PERSONALINFO."</th></tr>"
			."<tr class=\"bgcolor1\"><td width=\"25%\" valign=\"top\" align=\"center\">".$user_avatar."".$user_rank."<br /></td>"
			."<td width=\"75%\" valign=\"top\" rowspan=\"2\"><table border=\"0\" cellpadding=\"3\" cellspacing=\"0\">"
			."<tr><td width=\"25%\">"._NICKNAME.":</td><td>".$user_name."</td></tr>";
			if (preg_match("/([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})/", $userinfo['user_birthday'], $datetime)) echo "<tr><td>"._BIRTHDAY.":</td><td>".$datetime[3].".".$datetime[2].".".$datetime[1]."</td></tr>";
			if ($userinfo['user_gender'] == 0) {
				$user_gender = "<i>"._NO_INFO."</i>";
			} elseif ($userinfo['user_gender'] == 1) {
				$user_gender = ""._MAN."";
			} else {
				$user_gender = ""._WOMEN."";
			}
			preg_match("/([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})/", $userinfo['user_regdate'], $datetime);
			$user_regdate = "".$datetime[3].".".$datetime[2].".".$datetime[1]."";	
			echo "<tr><td>"._GENDER.":</td><td>".$user_gender."</td></tr>"
			."<tr><td>"._REG_DATE.":</td><td>".$user_regdate."</td></tr>"
			."<tr><td>"._LAST_VISIT.":</td><td>".gmdate('d.m.Y', $userinfo['user_lastvisit'])." "._IN." ".gmdate('H:i:s', $userinfo['user_lastvisit'])."</td></tr>";
			if ($update_points) {
				$user_points = intval($userinfo['user_points']);
				echo "<tr><td>"._POINTS.":</td><td>".$user_points."</td></tr>";
				$result = $db->sql_query("SELECT name FROM ".$prefix."_groups WHERE points<='$user_points' AND extra!='1'");
				$a = 1;
				while(list($uname) = $db->sql_fetchrow($result)) {
					$group_name .= ($a == 1) ? "".$uname."" : ", ".$uname."";
					$a++;
				}
				if (!$group_name) $group_name = "<i>"._NO_INFO."</i>";
				echo "<tr><td>"._USER_GROUPS.":</td><td>$group_name</td></tr>";
			}
			if (intval($userinfo['user_group'])) {
				echo "<tr><td>"._SPE_GROUP.":</td><td>$gr_extra_name</td></tr>";
			}
			if (intval($userinfo['user_warnings'])) {
				$user_warnings = intval($userinfo['user_warnings']);
				echo "<tr><td>"._WARNINGS.":</td><td>$user_warnings</td></tr>";
			}
			echo "<tr><td colspan=\"2\">&nbsp;</td></tr>";
			list($numcomments) = $db->sql_fetchrow($db->sql_query("SELECT Count(id) FROM ".$prefix."_comment WHERE uid='".$userinfo['user_id']."'"));
			if (!$numcomments) $numcomments = "0";
			echo "<tr><td>"._COMMENTS.":</td><td>".$numcomments."</td></tr>"
			."<tr><td>"._OCCUPATION.":</td><td>";
			if ($userinfo['user_occ'] != "") {
				echo "".$userinfo['user_occ']."";
			} else {
				echo "<i>"._NO_INFO."</i>";
			}
			echo "</td></tr><tr><td>"._LOCALITYLANG.":</td><td>";
			if ($userinfo['user_from'] != "") {
				echo "".$userinfo['user_from']."";
			} else {
				echo "<i>"._NO_INFO."</i>";
			}
			echo "</td></tr><tr><td>"._INTERESTS.":</td><td>";
			if ($userinfo['user_interests'] != "") {
				echo "".$userinfo['user_interests']."";
			} else {
				echo "<i>"._NO_INFO."</i>";
			}
			echo "</td></tr><tr><td>"._SIGNATURE.":</td><td>";
			if (bb_decode($userinfo['user_sig']) != "") {
				echo "".bb_decode($userinfo['user_sig'])."";
			} else {
				echo "<i>"._NO_INFO."</i>";
			}
			$fields = ($conffi['account']) ? "</td></tr><tr><td colspan=\"2\">".fields_out($userinfo['user_field'], $conffi['account'])."</td><td>" : "";
			echo "".$fields."</td></tr></table></td></tr>"
			."<tr class=\"bgcolor1\"><td><table border=\"0\" cellpadding=\"3\" cellspacing=\"0\">"
			."<tr><td><img border=\"0\" src=\"images/blocks/Home.gif\" width=\"16\" height=\"16\" alt=\""._FSITEURL."\"></td><td>";
			$user_website = preg_replace("/http\:\/\//", "", $userinfo['user_website']);
			if ($user_website != "") {
				echo "<a href=\"http://".$user_website."\" target=\"_blank\" title=\"".$user_website."\">".$user_website."</a>";
			} else {
				echo "<i>"._NO_INFO."</i>";
			}
			echo "</td></tr><tr><td><img border=\"0\" src=\"images/blocks/Contact.gif\" width=\"16\" height=\"16\" alt=\""._EMAIL."\"></td><td>";
			if ($userinfo['user_viewemail'] == 1 || is_admin($admin)) {
				echo "<a href=\"mailto:".$userinfo['user_email']."\" title=\"".$userinfo['user_email']."\">".$userinfo['user_email']."</a>";
			} else {
				echo "<i>"._NO_INFO."</i>";
			}
			echo "</td></tr><tr><td><img src=\"images/blocks/icq.gif\" width=\"16\" height=\"16\" alt=\"ICQ Number\"></td><td>";
			if ($userinfo['user_icq'] != "") {
				echo "".$userinfo['user_icq']."";
			} else {
				echo "<i>"._NO_INFO."</i>";
			}
			echo "</td></tr><tr><td><img src=\"images/blocks/aim.gif\" width=\"16\" height=\"16\" alt=\"AIM Address\"></td><td>";
			if ($userinfo['user_aim'] != "") {
				echo "".$userinfo['user_aim']."";
			} else {
				echo "<i>"._NO_INFO."</i>";
			}
			echo "</td></tr><tr><td><img src=\"images/blocks/yim.gif\" width=\"16\" height=\"16\" alt=\"Yahoo Messenger\"></td><td>";
			if ($userinfo['user_yim'] != "") {
				echo "".$userinfo['user_yim']."";
			} else {
				echo "<i>"._NO_INFO."</i>";
			}
			echo "</td></tr><tr><td><img src=\"images/blocks/msn.gif\" width=\"16\" height=\"16\" alt=\"MSN Messenger\"></td><td>";
			if ($userinfo['user_msnm'] != "") {
				echo "".$userinfo['user_msnm']."";
			} else {
				echo "<i>"._NO_INFO."</i>";
			}
			echo "</td></tr></table></td></tr>";
			if (is_admin($admin)) {
				echo "<tr><td width=\"100%\" class=\"bgcolor1\" colspan=\"2\" align=\"center\">[ <a href=\"".$admin_file.".php?op=SecurityBlocker&new_ip=".$userinfo['user_last_ip']."\" title=\""._BANIPSENDER."\">".$userinfo['user_last_ip']."</a> | <a href=\"".$admin_file.".php?op=DelUser&chng_user=$user_name\">"._DELETE."</a> | <a href=\"".$admin_file.".php?op=ModiUser&chng_user=$user_name\">"._EDIT."</a>]</td></tr>";
			}
			echo "</table>";
			CloseTable();
		}
		if ($my_headlines == 1 AND ($user_name == $cookie[1]) AND ($userinfo['user_password'] == $cookie[2])) {
			OpenTable();
			echo "<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"1\" align=\"center\" class=\"bgcolor4\">"
			."<tr><th colspan=\"2\">"._MYHEADLINES."</th></tr>"
			."<form action=\"index.php?name=$module_name\" method=\"post\">"
			."<input type=\"hidden\" name=\"op\" value=\"info\">"
			."<input type=\"hidden\" name=\"uname\" value=\"$uname\">"
			."<input type=\"hidden\" name=\"url\" value=\"0\">"
			."<tr class=\"bgcolor1\"><td>"._SELECTASITE.":</td><td><select name=\"hid\" onChange=\"submit()\" style=\"width:300px\">"
			."<option value=\"0\">"._SELECTASITE2."</option>";
			$headl = $db->sql_query("SELECT hid, sitename FROM ".$prefix."_headlines ORDER BY sitename");
			while(list($rhid, $rsitename) = $db->sql_fetchrow($headl)) {
				$rhid = intval($rhid);
				if ($hid == $rhid ) {
					$sel = "selected";
				} else {
					$sel = "";
				}
				echo "<option value=\"$rhid\" $sel>$rsitename</option>";
			}
			echo "</select></td></tr></form>"
			."<form action=\"index.php?name=$module_name\" method=\"post\">"
			."<input type=\"hidden\" name=\"op\" value=\"info\">"
			."<input type=\"hidden\" name=\"uname\" value=\"$uname\">"
			."<input type=\"hidden\" name=\"hid\" value=\"0\">"
			."<tr class=\"bgcolor1\"><td>"._ORTYPEURL.":</td><td>"
			."<input type=\"text\" name=\"url\" value=\"http://\" maxlength=\"200\" size=\"40\" style=\"width:300px\">"
			." <input type=\"submit\" value=\""._GO."\"></td></tr></form></table><br />";
			rss_load($url, $hid);
			CloseTable();
		}
		if ($broadcast_msg == 1 AND ($user_name == $cookie[1]) AND ($userinfo['user_password'] == $cookie[2])) {
			OpenTable();
			echo "<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"1\" align=\"center\" class=\"bgcolor4\">"
			."<tr><th>"._BROAD_CAST."</th></tr>"
			."<form action=\"index.php?name=$module_name\" method=\"post\">"
			."<input type=\"hidden\" name=\"who\" value=\"$user_name\">"
			."<input type=\"hidden\" name=\"op\" value=\"broadcast\">"
			."<tr class=\"bgcolor1\"><td align=\"center\"><input type=\"text\" name=\"the_message\" maxlength=\"255\" size=\"65\" style=\"width:400px\"> <input type=\"submit\" value=\""._SEND."\">"
			."<hr>"._BROADCASTTEXT."</td></tr></form></table>";
			CloseTable();
		}
		$result = $db->sql_query("SELECT cid, modul, date, comment FROM ".$prefix."_comment WHERE uid='".$userinfo['user_id']."' ORDER BY id DESC LIMIT 0,10");
		if ($db->sql_numrows($result) > 0) {
			OpenTable();
			echo "<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"1\" align=\"center\" class=\"bgcolor4\">"
			."<tr><th colspan=\"2\">"._LAST10COMMENTS."</th></tr>"
			."<tr class=\"bgcolor1\"><td><table border=\"0\" cellpadding=\"3\" cellspacing=\"0\">";
			while(list($cid, $modul, $date, $comment) = $db->sql_fetchrow($result)) {
				$cid = intval($cid);
				$date= text_filter($date);
				$comment = cutstr(text_filter(bb_decode($comment)), 70);
				if ($modul == "Files") {
					echo "<tr><td><img src=\"images/arrow.gif\" border=\"0\"></td><td>$date - <a href=\"index.php?name=Files&op=view_file&lid=$cid\" title=\"$comment\">$comment</a></td></tr>";
				} elseif ($modul == "Links") {
					echo "<tr><td><img src=\"images/arrow.gif\" border=\"0\"></td><td>$date - <a href=\"index.php?name=Links&op=view_link&lid=$cid\" title=\"$comment\">$comment</a></td></tr>";
				} elseif ($modul == "News") {
					echo "<tr><td><img src=\"images/arrow.gif\" border=\"0\"></td><td>$date - <a href=\"index.php?name=News&op=article&sid=$cid\" title=\"$comment\">$comment</a></td></tr>";
				} elseif ($modul == "Voting") {
					echo "<tr><td><img src=\"images/arrow.gif\" border=\"0\"></td><td> $date - <a href=\"index.php?name=Voting&op=poll_result&poll_id=$cid\" title=\"$comment\">$comment</a></td></tr>";
				}
			}
			echo "</table></td></tr></table>";
			CloseTable();
		}
		$result = $db->sql_query("SELECT sid, title, time FROM ".$prefix."_stories WHERE aid='$userinfo[user_name]' AND status='1' ORDER BY sid DESC LIMIT 0,10");
		if ($db->sql_numrows($result) > 0) {
			OpenTable();
			echo "<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"1\" align=\"center\" class=\"bgcolor4\">"
			."<tr><th colspan=\"2\">"._LAST10SUBMISSIONS."</th></tr>"
			."<tr class=\"bgcolor1\"><td><table border=\"0\" cellpadding=\"3\" cellspacing=\"0\">";
			while(list($sid, $title, $time) = $db->sql_fetchrow($result)) {
				$sid = intval($sid);
				$title = text_filter($title);
				$time = text_filter($time);
				echo "<tr><td><img src=\"images/arrow.gif\" border=\"0\"></td><td>$time - <a href=\"index.php?name=News&op=article&sid=$sid\" title=\"$title\">$title</a></td></tr>";
			}
			echo "</table></td></tr></table>";
			CloseTable();
		}
		foot();
	} else {
		$pagetitle = "$defis "._PERSONALINFO."";
		head();
		warning(""._USERNOEXIST."", "", 3, 2);
		foot();
	}
}

function main($user) {
    global $stop, $module_name, $gfx_chk;
    if(!is_user($user)) {
        head();
        if ($stop) {
            title(""._LOGININCOR."");
        } else {
			title(""._USERREGLOGIN."");
        }
        if (!is_user($user)) {
            OpenTable();
            echo "<form action=\"index.php?name=$module_name\" method=\"post\">"
			."<table border=\"0\" align=\"center\"><tr><td>"
			.""._NICKNAME.":</td><td><input type=\"text\" name=\"user_name\" size=\"10\" maxlength=\"25\"></td></tr>"
			."<tr><td>"._PASSWORD.":</td><td><input type=\"password\" name=\"user_password\" size=\"10\" maxlength=\"20\"></td></tr>";
            if (extension_loaded("gd") AND ($gfx_chk == 2 OR $gfx_chk == 4 OR $gfx_chk == 5 OR $gfx_chk == 7)) {
                echo "<tr><td>"._SECURITY_CODE.":</td><td><img src=\"index.php?captcha=1\" border=\"1\" alt=\""._SECURITY_CODE."\" title=\""._SECURITY_CODE."\"></td></tr>"
				."<tr><td>"._TYPESECCODE.":</td><td><input type=\"text\" name=\"check\" size=\"10\" maxlength=\"6\"></td></tr>";
            }
            echo "<tr><td colspan=\"2\" align=\"center\">"
			."<input type=\"hidden\" name=\"op\" value=\"login\"><br>"
			."<input type=\"submit\" value=\""._USERLOGIN."\"></td></tr></form></table><br>"
			."<center>[ <a href=\"index.php?name=$module_name&op=passlost\">"._PASSWORDLOST."</a> | <a href=\"index.php?name=$module_name&op=newuser\">"._REGNEWUSER."</a> ]</center>";
            CloseTable();
        }
        foot();
    } elseif (is_user($user)) {
		info($user[1]);
    }
}

function passlost() {
    global $user, $module_name;
    if (!is_user($user)) {
        head();
		title(""._PASSWORDLOST."");
        OpenTable();
		echo "<center>"._NOPROBLEM."</center><hr>"
		."<table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" align=\"center\">"
		."<form action=\"index.php?name=$module_name\" method=\"post\">"
		."<tr><td>"._NICKNAME.":</td><td><input type=\"text\" name=\"user_name\" size=\"11\" maxlength=\"25\"></td></tr>"
		."<tr><td>"._CONFIRMATIONCODE.":</td><td><input type=\"text\" name=\"code\" size=\"11\" maxlength=\"10\"></td></tr>"
		."<tr><td colspan=\"2\" align=\"center\"><br><input type=\"hidden\" name=\"op\" value=\"mailpass\">"
		."<input type=\"submit\" value=\""._SENDPASSWORD."\"></td></tr></form></table><br>"
		."<center>[ <a href=\"index.php?name=$module_name\">"._USERLOGIN."</a> | <a href=\"index.php?name=$module_name&op=newuser\">"._REGNEWUSER."</a> ]</center>";
        CloseTable();
        foot();
    } elseif(is_user($user)) {
		info($user[1]);
    }
}

function logout() {
    global $prefix, $db, $user, $redirect, $forum;
	$uid = intval($user[0]);
	$user_name = htmlspecialchars(substr($user[1], 0, 25));
    setcookie(USER_COOKIE, false);
    $db->sql_query("DELETE FROM ".$prefix."_session WHERE uname='$user_name'");
	if ($forum) log_out();
    $user = "";
    head();
    OpenTable();
	echo "<center><font class=\"title\">"._YOUARELOGGEDOUT."</font></center>";
    if ($redirect != "") {
        echo "<meta http-equiv=\"refresh\" content=\"3; url=index.php?name=$redirect\">";
    } else {
        echo "<meta http-equiv=\"refresh\" content=\"3; url=index.php\">";
    }
	CloseTable();
    foot();
}

function mailpass($user_name, $code) {
    global $sitename, $adminmail, $homeurl, $prefix, $db, $module_name, $minpass;
	$user_name = htmlspecialchars(substr($user_name, 0, 25));
    $sql = "SELECT user_email, user_password FROM ".$prefix."_users WHERE user_name='$user_name'";
    $result = $db->sql_query($sql);
    if($db->sql_numrows($result) == 0) {
		head();
		title(""._PASSWORDLOST."");
		OpenTable();
		echo "<center>"._SORRYNOUSERINFO."<br><br>"._GOBACK."</center>";
		CloseTable();
		foot();
    } else {
		$host_name = getenv("REMOTE_ADDR");
		$row = $db->sql_fetchrow($result);
		$user_email = htmlspecialchars($row['user_email']);
		$user_password = $row[user_password];
		$user_password = htmlspecialchars(stripslashes($user_password));
		$areyou = substr($user_password, 0, 10);
		if ($areyou == $code) {
			$newpass = gen_pass($minpass);
			$message = ""._USERACCOUNT." $user_name "._HASTHISEMAIL." "._AT." $sitename. "._AWEBUSERFROM." $host_name "._HASREQUESTED."<br /><br />"._YOURNEWPASSWORD." $newpass<br /><br />"._YOUCANCHANGE.": $homeurl/index.php?name=$module_name<br /><br />"._IFYOUDIDNOTASK."";
			$subject = "$sitename - "._USERPASSWORD4." $user_name";
			mail_send($user_email, $adminmail, $subject, $message, 0, 3);
			$cryptpass = md5($newpass);
			$query = "UPDATE ".$prefix."_users SET user_password='$cryptpass' WHERE user_name='$user_name'";
			if (!$db->sql_query($query)) echo ""._UPDATEFAILED."";
			head();
			title(""._PASSWORDLOST."");
			OpenTable();
			echo "<center>"._PASSWORD4." $user_name "._MAILED."<br><br>"._GOBACK."</center>";
			CloseTable();
			foot();
		} else {
			$sql = "SELECT user_email, user_password FROM ".$prefix."_users WHERE user_name='$user_name'";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) == 0) {
				head();
				title(""._PASSWORDLOST."");
				OpenTable();
				echo "<center>"._SORRYNOUSERINFO."<br><br>"._GOBACK."</center>";
				CloseTable();
				foot();
			} else {
				$host_name = getenv("REMOTE_ADDR");
				$row = $db->sql_fetchrow($result);
				$user_email = $row[user_email];
				$user_password = $row[user_password];
				$areyou = substr($user_password, 0, 10);
				$message = ""._USERACCOUNT." $user_name "._HASTHISEMAIL." "._AT." $sitename. "._AWEBUSERFROM." $host_name "._CODEREQUESTED."<br /><br />"._YOURCODEIS." $areyou<br /><br />"._WITHTHISCODE."<br /><br />$homeurl/index.php?name=$module_name&op=passlost<br /><br />"._IFYOUDIDNOTASK2."";
				$subject = "$sitename - "._CODEFOR." $user_name";
				mail_send($user_email, $adminmail, $subject, $message, 0, 3);
				head();
				title(""._PASSWORDLOST."");
				OpenTable();
				echo "<center>"._CODEFOR." $user_name "._MAILED."<br><br>"._GOBACK."</center>";
				CloseTable();
				foot();
			}
		}
	}
}

function login($check) {
    global $setinfo, $db, $module_name, $prefix, $forum, $gfx_chk, $sitekey;
    $user_password = htmlspecialchars(stripslashes($_POST['user_password']));
	$user_name = htmlspecialchars(substr($_POST['user_name'], 0, 25));
	$result = $db->sql_query("SELECT user_id, user_email, user_password, user_storynum, user_blockon, user_theme FROM ".$prefix."_users WHERE user_name='$user_name'");
    $setinfo = $db->sql_fetchrow($result);
	if (($db->sql_numrows($result) == 1) && ($setinfo[user_id] != "") && ($setinfo[user_password] != "")) {
		$dbpass = $setinfo[user_password];
        $non_crypt_pass = $user_password;
		$old_crypt_pass = crypt($user_password,substr($dbpass,0,2));
        $new_pass = md5($user_password);
        if (($dbpass == $non_crypt_pass) OR ($dbpass == $old_crypt_pass)) {
            $db->sql_query("UPDATE ".$prefix."_users SET user_password='$new_pass' WHERE user_name='$user_name'");
            list($dbpass) = $db->sql_fetchrow($db->sql_query("SELECT user_password FROM ".$prefix."_users WHERE user_name='$user_name'"));
        }
        if ($dbpass != $new_pass) {
            Header("Location: index.php?name=$module_name&stop=1");
			exit;
        }
		session_start();
		$code = substr(hexdec(md5("".date("F j")."".$_SESSION['captcha']."".$conf['sitekey']."")), 2, 6);
		unset($_SESSION['captcha']);
		if (extension_loaded("gd") AND $code != $check AND ($gfx_chk == 2 OR $gfx_chk == 4 OR $gfx_chk == 5 OR $gfx_chk == 7)) {
            Header("Location: index.php?name=$module_name&stop=1");
            exit;
        } else {
            cookieset($setinfo[user_id], $user_name, $new_pass, $setinfo[user_storynum], $setinfo[user_blockon], $setinfo[user_theme]);
            $uname = getenv("REMOTE_ADDR");
			$user_lastvisit = time();
            $db->sql_query("DELETE FROM ".$prefix."_session WHERE uname='$uname' AND guest='1'");
			$db->sql_query("UPDATE ".$prefix."_users SET user_last_ip='$uname', user_lastvisit='$user_lastvisit' WHERE user_name='$user_name'");
			if ($forum) {
				new_user($user_name, $new_pass, $setinfo[user_email]);
				log_in($user_name, $user_password);
			}
        }
		Header("Location: index.php?name=Account&op=info&uname=$user_name");
    } else {
		if ($forum) check_user($user_name, $user_password);
        Header("Location: index.php?name=$module_name&stop=1");
    }
}

function edithome() {
    global $user, $userinfo, $Default_Theme, $user_newsletter, $conffi, $broadcast_msg, $user_news, $storyhome, $module_name, $pagetitle, $defis, $update_points, $stop, $aupload, $adirectory, $atypefile, $amaxsize, $awidth, $aheight;
	$pagetitle = "$defis "._CHANGEHOME."";
    $cookie = $user;
    getusrinfo($user);
    if ((is_user($user)) AND (strtolower($userinfo['user_name']) == strtolower($cookie[1])) AND ($userinfo['user_password'] == $cookie[2])) {
		head();
		title(""._CHANGEHOME."");
		OpenTable();
		nav();
		CloseTable();
		if ($userinfo['user_theme'] == "") $userinfo['user_theme'] = "$Default_Theme";
		if ($stop) warning($stop, "", "", 1);
		OpenTable();
		preg_match("/([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})/", $userinfo['user_regdate'], $datetime);
		$user_regdate = "".$datetime[3].".".$datetime[2].".".$datetime[1]."";	
		echo "<form name=\"post\" action=\"index.php?name=$module_name\" method=\"post\">"
		."<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"1\" align=\"center\" class=\"bgcolor4\">";
		echo "<tr><th colspan=\"2\">"._PERSONALINFO."</th></tr>"
		."<tr class=\"bgcolor1\"><td>"._IP.":</td><td>".$userinfo['user_last_ip']."</td></tr>"
		."<tr class=\"bgcolor1\"><td>"._REG_DATE.":</td><td>".$user_regdate."</td></tr>";
		if ($update_points) echo "<tr class=\"bgcolor1\"><td>"._POINTS.":</td><td>".$userinfo['user_points']."</td></tr>";
		echo "<tr class=\"bgcolor1\"><td>"._YOURNAME.":</td><td>".$userinfo['user_name']."</td></tr>";
		preg_match("/([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})/", $userinfo['user_birthday'], $datetime);
		echo "<tr class=\"bgcolor1\"><td>"._BIRTHDAY.": </td><td>"._DAY.": <select name=\"day\">";
		$day = 1;
		while ($day <= 31) {
			echo "<option name=\"day\" ";
			if ($day == $datetime[3]) echo "selected";
			echo ">$day</option>";
			$day++;
		}
		echo "</select> "._UMONTH.": <select name=\"month\">";
		$month = 1;
		while ($month <= 12) {
			echo "<option name=\"month\" ";
			if ($month == $datetime[2]) echo "selected";
			echo ">$month</option>";
			$month++;
		}
		echo "</select> "._YEAR.": <select name=\"year\">";
		$date = getdate();
		$year = $date[year] - 100;
		while ($year <= $date[year]) {
			echo "<option name=\"year\" ";
			if ($year == $datetime[1]) echo "selected";
			echo ">$year</option>";
			$year++;
		}
		echo "</select></td></tr>"
		."<tr class=\"bgcolor1\"><td>"._GENDER.": </td><td>";
		if ($userinfo['user_gender'] == 0) {
			echo "<input type=\"radio\" name=\"user_gender\" value=\"0\" checked> "._NO_INFO." <input type=\"radio\" name=\"user_gender\" value=\"1\"> "._MAN." <input type=\"radio\" name=\"user_gender\" value=\"2\"> "._WOMEN."";
		} elseif ($userinfo['user_gender'] == 1) {
			echo "<input type=\"radio\" name=\"user_gender\" value=\"0\"> "._NO_INFO." <input type=\"radio\" name=\"user_gender\" value=\"1\" checked> "._MAN." <input type=\"radio\" name=\"user_gender\" value=\"2\"> "._WOMEN."";
		} else {
			echo "<input type=\"radio\" name=\"user_gender\" value=\"0\"> "._NO_INFO." <input type=\"radio\" name=\"user_gender\" value=\"1\"> "._MAN." <input type=\"radio\" name=\"user_gender\" value=\"2\" checked> "._WOMEN."";
		}
		echo "</td></tr>"
		."<tr class=\"bgcolor1\"><td>"._YOUREMAIL.": <font class=\"option\">*</font></td><td><input type=\"text\" name=\"user_email\" value=\"".$userinfo['user_email']."\" maxlength=\"60\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>ICQ Number:</td><td><input type=\"text\" name=\"user_icq\" value=\"".$userinfo['user_icq']."\" maxlength=\"15\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>AIM Address:</td><td><input type=\"text\" name=\"user_aim\" value=\"".$userinfo['user_aim']."\" maxlength=\"18\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>MSN Messenger:</td><td><input type=\"text\" name=\"user_msnm\" value=\"".$userinfo['user_msnm']."\" maxlength=\"25\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>Yahoo Messenger:</td><td><input type=\"text\" name=\"user_yim\" value=\"".$userinfo['user_yim']."\" maxlength=\"25\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>"._FSITEURL.":</td><td><input type=\"text\" name=\"user_website\" value=\"".$userinfo['user_website']."\" maxlength=\"100\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>"._OCCUPATION.":</td><td><input type=\"text\" name=\"user_occ\" value=\"".$userinfo['user_occ']."\" maxlength=\"100\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>"._LOCALITYLANG.":</td><td><input type=\"text\" name=\"user_from\" value=\"".$userinfo['user_from']."\" maxlength=\"100\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>"._INTERESTS.":</td><td><input type=\"text\" name=\"user_interests\" value=\"".$userinfo['user_interests']."\" maxlength=\"150\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>"._SIGNATURE.":<br /><font class=\"small\">"._SIGNATURE_TEXT."</font></td><td>"
		."<textarea id=\"area1\" name=\"comment\" cols=\"65\" rows=\"5\" style=\"width:400px\" OnKeyPress=\"TransliteFeld(this, event)\" OnSelect=\"FieldName(this, this.name)\" OnClick=\"FieldName(this, this.name)\" OnKeyUp=\"FieldName(this, this.name)\">".replace_break($userinfo['user_sig'])."</textarea>".get_code("area1")."</td></tr>";
		if ($conffi['account']) echo "".fields_in($userinfo['user_field'], $conffi['account'])."";
		echo "<tr><th colspan=\"2\">"._CHANGEHOME."</th></tr>";
		if ($user_news == 1) {
			echo "<tr class=\"bgcolor1\"><td>"._NEWSINHOME.":</td><td><select name=\"user_storynum\" style=\"width:400px\">";
			echo "<option value=\"3\"";
			if ($userinfo['user_storynum'] == "3") echo " selected";
			echo ">"._NEWSINHOME." - 3</option>";
			echo "<option value=\"5\"";
			if ($userinfo['user_storynum'] == "5") echo " selected";
			echo ">"._NEWSINHOME." - 5</option>";
			echo "<option value=\"10\"";
			if ($userinfo['user_storynum'] == "10") echo " selected";
			echo ">"._NEWSINHOME." - 10</option>";
			echo "<option value=\"15\"";
			if ($userinfo['user_storynum'] == "15") echo " selected";
			echo ">"._NEWSINHOME." - 15</option>";
			echo "<option value=\"20\"";
			if ($userinfo['user_storynum'] == "20") echo " selected";
			echo ">"._NEWSINHOME." - 20</option></select></td></tr>";
		} else {
			echo "<input type=\"hidden\" name=\"user_storynum\" value=\"$storyhome\">";
		}
		if ($broadcast_msg == 1) {
			if ($userinfo['user_broadcast'] == 1) {
				$sel1 = "checked";
				$sel2 = "";
			} elseif ($userinfo['user_broadcast'] == 0) {
				$sel1 = "";
				$sel2 = "checked";
			}
			echo "<tr class=\"bgcolor1\"><td>"._MESSAGEACTIVATE.":</td><td><input type=\"radio\" name=\"user_broadcast\" value=\"1\" $sel1>"._YES." &nbsp;&nbsp; <input type=\"radio\" name=\"user_broadcast\" value=\"0\" $sel2>"._NO."</td></tr>";
		} else {
			echo "<input type=\"hidden\" name=\"user_broadcast\" value=\"1\">";
		}
		echo "<tr class=\"bgcolor1\"><td>"._RECEIVENEWSLETTER.":</td><td>";
		if ($userinfo['user_newsletter'] == 1) {
			echo " <input type=\"radio\" name=\"user_newsletter\" value=\"1\" checked>"._YES." &nbsp;&nbsp; <input type=\"radio\" name=\"user_newsletter\" value=\"0\">"._NO."";
		} elseif ($userinfo['user_newsletter'] == 0) {
			echo " <input type=\"radio\" name=\"user_newsletter\" value=\"1\">"._YES." &nbsp;&nbsp; <input type=\"radio\" name=\"user_newsletter\" value=\"0\" checked>"._NO."";
		}
		echo "</td></tr>";
		if ($userinfo['user_viewemail'] == 1) $sel3 = "checked";
		echo "<tr class=\"bgcolor1\"><td>"._ALLOWUSERS.":</td><td><input type=\"checkbox\" name=\"user_viewemail\" value=\"1\" $sel3></td></tr>";
		if ($userinfo['user_blockon'] == 1) $sel4 = "checked";
		echo "<tr class=\"bgcolor1\"><td>"._ACTIVATEPERSONAL.":</td><td><input type=\"checkbox\" name=\"user_blockon\" value=\"1\" $sel4></td></tr>"
        ."<tr class=\"bgcolor1\"><td>"._HOMECONFIG.":<br /><font class=\"small\">"._CHECKTHISOPTION."</font></td><td>"
		."<textarea id=\"area2\" name=\"comment2\" cols=\"65\" rows=\"5\" style=\"width:400px\" OnKeyPress=\"TransliteFeld(this, event)\" OnSelect=\"FieldName(this, this.name)\" OnClick=\"FieldName(this, this.name)\" OnKeyUp=\"FieldName(this, this.name)\">".replace_break($userinfo['user_block'])."</textarea>".get_code("area2")."</td></tr>";
		$tdir = opendir("templates");
		while ($tfile = readdir($tdir)) {
			if (!preg_match("/\./", $tfile) && $tfile != "Admin") { 
				$ttitle = str_replace("_", " ", $tfile);
				if ($tfile == $userinfo['user_theme']) {
					$tcategory .= "<option value=\"$tfile\" selected>".$ttitle."</option>";
				} else {
					$tcategory .= "<option value=\"$tfile\">".$ttitle."</option>";
				}
				$tcount++;
			}
		}
		closedir($tdir);
		if ($tcount > 1) {
			echo "<tr class=\"bgcolor1\"><td>"._SELECTTHEME.":<br /><font class=\"small\">"._THEMETEXT."</font></td><td><select name=\"user_theme\" style=\"width:400px\">".$tcategory."</select></td></tr>";
		}
		echo "<tr class=\"bgcolor1\"><td colspan=\"2\" align=\"center\"><input type=\"hidden\" name=\"user_name\" value=\"$userinfo[user_name]\">"
        ."<input type=\"hidden\" name=\"user_id\" value=\"$userinfo[user_id]\">"
        ."<input type=\"hidden\" name=\"op\" value=\"savehome\">"
        ."<input type=\"submit\" value=\""._SAVECHANGES."\"></td></tr></form>";
		echo "<tr><th colspan=\"2\">"._AVATARSETUP."</th></tr>";
		$user_avatar = (!$userinfo[user_avatar]) ? "00.gif" : $userinfo[user_avatar];
		echo "<tr class=\"bgcolor1\"><td>"._AVATAR.":<br /><font class=\"small\">".sprintf(""._AVATARINFO."", $awidth, $aheight, files_size($amaxsize))."</font></td><td align=\"center\"><img src=\"".$adirectory."/".$user_avatar."\"></td></tr>";
		$adir = opendir("".$adirectory."");
		while ($afile = readdir($adir)) {
			if (!preg_match("/\./", $afile)) { 
				$atitle = str_replace("_", " ", $afile);
				$acategory .= "<option value=\"$afile\">"._ALBUM." - ".$atitle."</option>";
				$acount++;
			}
		}
		closedir($adir);
		if ($acount >= 1) {
			echo "<form action=\"index.php?name=$module_name\" method=\"post\">"
			."<tr class=\"bgcolor1\"><td>"._AVATARSELECT.":</td><td>"
			."<select name=\"category\" style=\"width:350px\">".$acategory."</select>"
			." <input type=\"hidden\" name=\"op\" value=\"avatar\">"
			."<input type=\"hidden\" name=\"user_id\" value=\"$userinfo[user_id]\">"
			."<input type=\"submit\" value=\""._OK."\" style=\"width:45px\"></td></tr></form>";
		}
		if ($aupload) {
			echo "<form enctype=\"multipart/form-data\" action=\"index.php?name=$module_name\" method=\"post\">"
			."<tr class=\"bgcolor1\"><td>"._AVATAR_USER.":</td><td><input type=\"file\" name=\"userfile\" value=\"\" size=\"65\" style=\"width:400px\"></td></tr>"
			."<tr class=\"bgcolor1\"><td>"._AVATAR_SITE.":<br /><font class=\"small\">"._AVATAR_SITETEXT."</font></td><td><input type=\"text\" name=\"sitefile\" value=\"\" size=\"65\" style=\"width:400px\"></td></tr>"
			."<tr class=\"bgcolor1\"><td colspan=\"2\" align=\"center\"><input type=\"hidden\" name=\"op\" value=\"saveavatar\">"
			."<input type=\"submit\" value=\""._SAVECHANGES."\"></td></tr></form>";
		}
		echo "<tr><th colspan=\"2\">"._PASSSETUP."</th></tr>"
		."<form action=\"index.php?name=$module_name\" method=\"post\">"
		."<tr class=\"bgcolor1\"><td>"._PASSOLD.":<br /><font class=\"small\">"._PASSTEXT."</font></td><td><input type=\"text\" name=\"oldpass\" maxlength=\"10\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>"._PASSNEW.":</td><td><input type=\"text\" name=\"newpass\" maxlength=\"10\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td>"._PASSNEW2.":</td><td><input type=\"text\" name=\"newpass2\" maxlength=\"10\" size=\"45\" style=\"width:400px\"></td></tr>"
		."<tr class=\"bgcolor1\"><td colspan=\"2\" align=\"center\"><input type=\"hidden\" name=\"op\" value=\"savepass\">"
		."<input type=\"submit\" value=\""._SAVECHANGES."\"></td></tr></form></table>";
		CloseTable();
		foot();
    } else {
		main($user);
	}
}

function savehome($user_id, $user_email, $user_website, $user_icq, $user_occ, $user_from, $user_interests, $comment, $user_viewemail, $user_theme, $user_aim, $user_yim, $user_msnm, $user_storynum, $user_blockon, $comment2, $user_broadcast, $user_newsletter, $day, $month, $year, $user_gender) {
    global $user, $userinfo, $prefix, $db, $module_name, $stop;
	checkemail($user_email);
    if (!$stop) {
		$check = htmlspecialchars(substr($user[1], 0, 25));
		$check2 = htmlspecialchars(stripslashes($user[2]));
		list($vuid, $ccpass) = $db->sql_fetchrow($db->sql_query("SELECT user_id, user_password FROM ".$prefix."_users WHERE user_name='$check'"));
		$vuid = intval($vuid);
		if (($user_id == $vuid) AND ($check2 == $ccpass)) {
			$user_id = intval($user_id);
			$user_email = text_filter($user_email);
			$user_website = text_filter($user_website);
			if (!preg_match("/http\:\/\//", $user_website)) $user_website = "http://$user_website";
			$user_website = ($user_website == "http://") ? "" : $user_website;
			$user_icq = text_filter($user_icq);
			$user_occ = text_filter($user_occ);
			$user_from = text_filter($user_from);
			$user_interests = text_filter($user_interests);
			$user_sig = nl2br(text_filter($comment, 2));
			$user_viewemail = intval($user_viewemail);
			$user_theme = text_filter($user_theme);
			$user_aim = text_filter($user_aim);
			$user_yim = text_filter($user_yim);
			$user_msnm = text_filter($user_msnm);
			$user_storynum = intval($user_storynum);
			$user_blockon = intval($user_blockon);
			$user_block = nl2br(text_filter($comment2));
			$user_broadcast = intval($user_broadcast);
			$user_newsletter = intval($user_newsletter);
			$day = intval($day);
			$month = intval($month);
			$year = intval($year);
			$user_birthday = "$year-$month-$day";
			$user_field = fields_save($_POST['field']);
			$db->sql_query("UPDATE ".$prefix."_users SET user_email='$user_email', user_website='$user_website', user_viewemail='$user_viewemail', user_icq='$user_icq', user_occ='$user_occ', user_from='$user_from', user_interests='$user_interests', user_sig='$user_sig', user_theme='$user_theme', user_aim='$user_aim', user_yim='$user_yim', user_msnm='$user_msnm', user_storynum='$user_storynum', user_blockon='$user_blockon', user_block='$user_block', user_broadcast='$user_broadcast', user_newsletter='$user_newsletter', user_birthday='$user_birthday', user_gender='$user_gender', user_field='$user_field' WHERE user_id='$user_id'");
			getusrinfo($user);
			cookieset($userinfo[user_id], $userinfo[user_name], $userinfo[user_password], $userinfo[user_storynum], $userinfo[user_blockon], $userinfo[user_theme]);
			Header("Location: index.php?name=$module_name&op=edithome");
		}
	} else {
		edithome();
	}
}

function broadcast($the_message, $who) {
	global $prefix, $db, $broadcast_msg, $module_name, $user, $userinfo;
    $cookie = $user;
    getusrinfo($user);
    if ((is_user($user)) AND (strtolower($who) == strtolower($cookie[1])) AND (strtolower($userinfo['user_name']) == strtolower($cookie[1])) AND ($userinfo['user_password'] == $cookie[2])) {
		$who = $cookie[1];
		if ($broadcast_msg == 1) {
			head();
			title(""._BROAD_CAST."");
			$who = htmlspecialchars(substr($who, 0, 25));
			$numrows = $db->sql_numrows($db->sql_query("SELECT * FROM ".$prefix."_public_messages WHERE who='$who'"));
			$the_message = text_filter($the_message);
			if ($the_message != "" AND $numrows == 0) {
				$the_time = time();
				$db->sql_query("INSERT INTO ".$prefix."_public_messages VALUES (NULL, '$the_message', '$the_time', '$who')");
				update_points(20);
				warning(""._BROADCASTSENT."", "?name=$module_name", 3, 2);
			} else {
				warning(""._BROADCASTNOTSENT."", "?name=$module_name", 3, 1);
			}
			foot();
		} else {
			main($user);
		}
    }
}

function avatar($category) {
	global $module_name, $pagetitle, $defis, $adirectory;
	$pagetitle = "$defis "._AVATARSETUP."";
	head();
	title(""._AVATARSETUP."");
	Opentable();
	nav();
	CloseTable();
	OpenTable();
	echo "<center>";
	$dir = opendir("".$adirectory."/".$category."");
	$temcount = 1;
	while ($entry = readdir($dir)) {
		if (preg_match("/(\.gif|\.png|\.jpg|\.jpeg)$/is", $entry) && $entry != "." && $entry != "..") {
			$entryname = str_replace("_", " ", preg_replace("/^(.*)\..*$/", "\\1", $entry));
			echo "<a href=\"index.php?name=$module_name&op=saveavatar&category=$category&avatar=$entry\"><img src=\"".$adirectory."/$category/$entry\" border=\"0\" alt=\""._AVATARSAVE." - ".$entryname."\" title=\""._AVATARSAVE." - ".$entryname."\" hspace=\"5\" vspace=\"5\"></a>";
			if ($temcount == 5) {
				echo "<br />";
				$temcount -= 5;
			}
			$temcount ++;
		}
	}
	closedir($dir);
	echo "</center>";
	CloseTable();
	get_page($module_name);
	foot();
}

function saveavatar($category, $avatar) {
	global $user, $userinfo, $prefix, $db, $module_name, $stop, $aupload, $adirectory, $atypefile, $amaxsize, $awidth, $aheight;
	if (is_user($user)) {
        $user_id = intval($user[0]);
		if (!$avatar && !$category && $aupload) {
			$upload_avatar = upload($adirectory, $atypefile, $amaxsize, $user_id, $awidth, $aheight);
			$avatar = (!$upload_avatar) ? $avatar : $upload_avatar;
		} elseif ($avatar && $category) {
			$avatar = "".$category."/".$avatar."";
		}
		if (!$stop && $avatar) {
			$avatar = text_filter($avatar);
			$db->sql_query("UPDATE ".$prefix."_users SET user_avatar='$avatar' WHERE user_id='$user_id'");
			Header("Location: index.php?name=$module_name&op=edithome");
		} else {
			edithome();
		}
	} else {
		edithome();
	}
}

function savepass($oldpass, $newpass, $newpass2) {
	global $user, $prefix, $db, $module_name, $minpass, $userinfo, $adminmail, $sitename, $homeurl, $stop;
	if (is_user($user) && $oldpass && $newpass && $newpass2) {
		if (strlen($newpass) >= $minpass) {
			$oldpass = md5($oldpass);
			$user_id = intval($user[0]);
			list($pass) = $db->sql_fetchrow($db->sql_query("SELECT user_password FROM ".$prefix."_users WHERE user_id='$user_id'"));
			if ($pass == $oldpass && $pass != "") {
				if ($newpass == $newpass2) {
					getusrinfo($user);
					$user_email = $userinfo['user_email'];
					$user_name = $userinfo['user_name'];
					$host_name = getenv("REMOTE_ADDR");
					$message = ""._USERACCOUNT." $user_name "._HASTHISEMAIL." "._AT." $sitename. "._AWEBUSERFROM." $host_name "._HASREQUESTED."<br /><br />"._YOURNEWPASSWORD." $newpass<br /><br />"._YOUCANCHANGE.": $homeurl/index.php?name=$module_name<br /><br />"._IFYOUDIDNOTASK."";
					$subject = "$sitename - "._USERPASSWORD4." $user_name";
					mail_send($user_email, $adminmail, $subject, $message, 0, 3);
					$newpass = md5($newpass);
					$newpass = htmlspecialchars(stripslashes($newpass));
					$db->sql_query("UPDATE ".$prefix."_users SET user_password='$newpass' WHERE user_id='$user_id'");
					Header("Location: index.php?name=$module_name");
				} else {
					$stop = ""._ERRORNEW."";
					edithome();
				}
			} else {
				$stop = ""._ERROROLD."";
				edithome();
			}
		} else {
			$stop = ""._CHARMIN.": $minpass";
			edithome();
		}
	} else {
		edithome();
	}
}

switch($op) {
	case "logout":
	logout();
	break;

    case "broadcast":
	broadcast($the_message, $who);
	break;

    case "confnewuser":
	confnewuser($user_name, $user_email, $rulescheck, $user_password, $user_password2, $check);
	break;

    case "finnewuser":
	finnewuser($user_name, $user_email, $rulescheck, $user_password, $check);
	break;

    case "mailpass":
	mailpass($user_name, $code);
	break;

    case "info":
	info($uname, $hid, $url);
	break;

    case "login":
	login($check);
	break;

    case "edithome":
	edithome();
	break;

    case "savehome":
	savehome($user_id, $user_email, $user_website, $user_icq, $user_occ, $user_from, $user_interests, $comment, $user_viewemail, $user_theme, $user_aim, $user_yim, $user_msnm, $user_storynum, $user_blockon, $comment2, $user_broadcast, $user_newsletter, $day, $month, $year, $user_gender);
	break;
	
	case "passlost":
	passlost();
	break;

    case "newuser":
	newuser();
	break;

    case "activate":
	activate($user_name, $check_num);
	break;

	case "avatar":
	avatar($category);
	break;
	
	case "saveavatar":
	saveavatar($category, $avatar);
	break;

	case "savepass":
	savepass($oldpass, $newpass, $newpass2);
	break;

    default:
	main($user);
	break;
}
?>